/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.indication.server;

import com.ibm.hsc.common.util.HSCLogUtils;
import com.ibm.hsc.indication.client.HSCEvent;
import com.ibm.hsc.indication.client.HSCSocket;
import com.ibm.hsc.indication.client.HSCSubscription;
import com.ibm.hsc.indication.server.HSCObjectSender;
import java.io.IOException;
import java.sql.Timestamp;
import java.util.Vector;

public class HSCListener {
    private static int mNextId = 0;
    private int mId = ++mNextId;
    private int mSubCount = 0;
    private int mUnsubCount = 0;
    private HSCSocket mSocket;
    private boolean mClosed;
    private boolean mNeedClose;
    private HSCObjectSender mObjSender = null;
    private Vector mQueuedObjs = new Vector();
    private String mAuthKey = null;
    private long mConnCreateTime;
    private Vector mEvents;
    private String mClientInfo = null;

    public HSCListener(HSCSocket hSCSocket) {
        this.mSocket = hSCSocket;
        this.mNeedClose = false;
        this.mClosed = false;
        this.mEvents = new Vector();
        this.mConnCreateTime = System.currentTimeMillis();
    }

    public String getAuthKey() {
        return this.mAuthKey;
    }

    public void printStatus() {
        System.out.println("mClosed: " + this.mClosed);
        System.out.println("mSubCount: " + this.mSubCount);
        System.out.println("mUnsubCount: " + this.mUnsubCount);
        System.out.println("mId: " + this.mId);
        System.out.println("mNeedClose: " + this.mNeedClose);
        System.out.println("mConnCreationTime: " + new Timestamp(this.mConnCreateTime));
        System.out.println("mAuthKey: " + this.mAuthKey);
        System.out.println("mEvents: " + this.mEvents);
        if (this.mQueuedObjs != null) {
            System.out.println("mQueuedObjs.size(): " + this.mQueuedObjs.size());
        } else {
            System.out.println("mQueuedObjs is null");
        }
        if (this.mObjSender == null) {
            System.out.println("mObjSender is null.");
        } else {
            System.out.println("mLastWriteTime: " + new Timestamp(this.mObjSender.getLastWriteTime()));
        }
    }

    public String subscribe(HSCSubscription hSCSubscription) {
        String string = hSCSubscription.getEventKey();
        System.out.println("subscribe event with key: " + string + " id " + this.mId);
        ++this.mSubCount;
        if (this.mAuthKey == null) {
            this.mAuthKey = hSCSubscription.getAuthKey();
            System.out.println("set auth key: " + this.mAuthKey + " id " + this.mId);
        } else {
            if (!this.mAuthKey.equals(hSCSubscription.getAuthKey())) {
                System.out.println("auth key not equal, id " + this.mId);
                System.out.println("mAuthKey: " + this.mAuthKey);
                System.out.println("sub.getAuthKey(): " + hSCSubscription.getAuthKey());
                return null;
            }
            if (this.mEvents.indexOf(string) != -1) {
                System.out.println("event has been subscribed " + this.mId);
                return null;
            }
        }
        this.mEvents.addElement(string);
        return string;
    }

    public String unsubscribe(HSCSubscription hSCSubscription) {
        String string = hSCSubscription.getEventKey();
        System.out.println("unsubscribe event with key: " + string + " id " + this.mId);
        ++this.mUnsubCount;
        if (this.mAuthKey == null) {
            return null;
        }
        if (!this.mAuthKey.equals(hSCSubscription.getAuthKey())) {
            return null;
        }
        if (this.mEvents.indexOf(string) == -1) {
            return null;
        }
        this.mEvents.removeElement(string);
        return string;
    }

    public Vector getEventKeys() {
        return this.mEvents;
    }

    public HSCSubscription readSubscription() throws IOException {
        HSCSubscription hSCSubscription = null;
        Object object = this.mSocket.readObject();
        if (object != null) {
            hSCSubscription = (HSCSubscription)object;
            System.out.println("is subscribe " + hSCSubscription.isSubscription() + " id " + this.mId);
        }
        return hSCSubscription;
    }

    public void deliverEvent(HSCEvent hSCEvent) {
        System.out.println("deliver event to " + this.mId + " objtype " + hSCEvent.getObjectType() + " evttype " + hSCEvent.getEventType());
        this.sendOutObject(hSCEvent);
    }

    private synchronized void sendOutObject(Object object) {
        if (this.mNeedClose) {
            System.out.println("listener closed, event is not sent");
            return;
        }
        this.accessQueuedObjects(object, false);
    }

    public synchronized Object accessQueuedObjects(Object object, boolean bl) {
        if (bl) {
            return this.mObjSender;
        }
        if (this.mClosed) {
            return null;
        }
        if (object != null) {
            if (this.mObjSender == null) {
                this.mObjSender = new HSCObjectSender(this.mSocket, object, this);
                this.mObjSender.start();
            } else if (this.mQueuedObjs != null) {
                this.mQueuedObjs.addElement(object);
            } else {
                System.out.println("mQueuedObjs is null. cannot add");
            }
            return null;
        }
        if (this.mQueuedObjs.size() == 0) {
            this.mObjSender = null;
            return null;
        }
        return this.mQueuedObjs.remove(0);
    }

    public boolean handleTimeOut(long l) {
        HSCObjectSender hSCObjectSender = (HSCObjectSender)this.accessQueuedObjects(null, true);
        if (hSCObjectSender == null) {
            return false;
        }
        long l2 = hSCObjectSender.getLastWriteTime();
        if (l2 == 0L) {
            return false;
        }
        if (l - l2 > 30000L) {
            System.out.println("Timeout after 30 seconds  id + " + this.mId + "\n\n\n\n");
            this.close();
            System.out.println("after close");
            hSCObjectSender.interrupt();
            System.out.println("aft interrupt");
            this.mNeedClose = true;
            return true;
        }
        return false;
    }

    public void sendSubStatus(HSCSubscription hSCSubscription) throws IOException {
        this.sendOutObject(hSCSubscription);
    }

    public void close() {
        if (this.mClosed) {
            return;
        }
        try {
            this.mSocket.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            HSCLogUtils.serverLog(exception, HSCLogUtils._IndicationClassLogInfo);
        }
        this.mQueuedObjs = null;
        this.mObjSender = null;
        this.mClosed = true;
        this.mNeedClose = true;
    }

    public boolean isNeedClose() {
        return this.mNeedClose;
    }

    public void setNeedClose() {
        System.out.println("set need close time out after 4 second, id " + this.mId + "\n\n\n\n");
        this.mNeedClose = true;
    }
}

